/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.graphics.Bitmap;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.gprinter.bean.PrinterDevices;
import com.gprinter.io.PortManager;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.Command;
import com.gprinter.utils.GpUtils;
import com.gprinter.utils.LogUtils;
import com.gprinter.utils.PDFUtils;
import com.gprinter.utils.SDKUtils;
import com.gprinter.utils.SerialPortControl;
import com.gprinter.utils.UIThreadManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SerialPort
extends PortManager {
    private static final String TAG = SerialPort.class.getSimpleName();
    private int baudrate;
    private String serialPortPath;
    private SerialPortControl serialPortControl;
    private int len = 0;
    private int SINGLE_SIZE = 64;
    private boolean isConn = false;
    private boolean isBusy = false;
    private Command command = null;
    private CallbackListener callbackListener;
    private byte[] buffer = new byte[128];
    private IoReader reader = null;
    private final Object lock = new Object();
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private PrinterDevices mPrinterDevices = null;

    public SerialPort(PrinterDevices devices) {
        if (devices != null) {
            this.mPrinterDevices = devices;
            this.serialPortPath = devices.getSerialPortPath();
            this.baudrate = devices.getBaudRate();
            this.callbackListener = devices.getCallbackListener();
            this.command = devices.getCommand();
        }
    }

    @Override
    public synchronized boolean openPort() {
        try {
            File file;
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SerialPort.this.callbackListener.onConnecting();
                    }
                });
            }
            if ((file = new File(this.serialPortPath)).exists()) {
                this.serialPortControl = new SerialPortControl(file, this.baudrate, 0);
                this.inputStream = this.serialPortControl.getInputStream();
                this.outputStream = this.serialPortControl.getOutputStream();
                if (this.inputStream != null && this.outputStream != null) {
                    if (this.callbackListener != null) {
                        if (this.command == null) {
                            UIThreadManager.onUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    SerialPort.this.callbackListener.onCheckCommand();
                                }
                            });
                            this.checkPrinterCommand();
                        } else {
                            this.setSuccessListen(this.command);
                        }
                    }
                    this.isConn = true;
                    this.reader = new IoReader();
                    this.reader.start();
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.setFailureListen();
        }
        catch (Exception e) {
            this.setFailureListen();
            Log.e((String)TAG, (String)("OS File error" + e.getMessage()));
        }
        return false;
    }

    private void checkPrinterCommand() throws IOException {
        int status = -1;
        status = this.getPrinterStatus(Command.ESC);
        if (status == -1) {
            status = this.getPrinterStatus(Command.CPCL);
            if (status == -1) {
                status = this.getPrinterStatus(Command.TSC);
                if (status == -1) {
                    this.setFailureListen();
                } else {
                    this.setSuccessListen(Command.TSC);
                }
            } else {
                this.setSuccessListen(Command.CPCL);
            }
        } else {
            this.setSuccessListen(Command.ESC);
        }
    }

    private void setSuccessListen(Command command) {
        this.command = command;
        this.mPrinterDevices.setCommand(this.command);
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    SerialPort.this.callbackListener.onSuccess(SerialPort.this.mPrinterDevices);
                }
            });
        }
    }

    private void setFailureListen() {
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    SerialPort.this.callbackListener.onFailure();
                }
            });
        }
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToEsc(File file, int width) throws Exception {
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, width);
        if (bitmaps == null) {
            return false;
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            byte[] data = PDFUtils.drawEscPDF(bitmaps[i]);
            this.writeDataImmediately(data);
            if (i != bitmaps.length - 1) continue;
            return true;
        }
        byte[] command = new byte[]{10, 29, 86, 66, 0, 27, 64};
        this.writeDataImmediately(command);
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToTsc(File file, int printWidth, int gap, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (file == null) {
            throw new Exception("File cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(gap))) {
            throw new Exception("gap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, printWidth);
        if (bitmaps == null) {
            return false;
        }
        if (gap > 0 | cutHeight == 0) {
            for (int i = 0; i < bitmaps.length; ++i) {
                byte[] data;
                String size = "\r\nSIZE " + bitmaps[i].getWidth() / (dpi200 ? 8 : 12) + " mm," + bitmaps[i].getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String GAP = "GAP " + gap + " mm,0 mm\r\n";
                if (cut && i == bitmaps.length - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                this.writeDataImmediately(GAP.getBytes("GB18030"));
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                if (compression) {
                    data = PDFUtils.drawTscPDFLib(bitmaps[i]);
                    this.writeDataImmediately(data);
                } else {
                    data = PDFUtils.drawTscPDF(bitmaps[i]);
                    this.writeDataImmediately(data);
                }
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (i != bitmaps.length - 1) continue;
                return true;
            }
        } else {
            for (int i = 0; i < bitmaps.length; ++i) {
                List<Bitmap> mlist = SerialPort.ImageCrop(bitmaps[i], cutHeight);
                for (int j = 0; j < mlist.size(); ++j) {
                    byte[] data;
                    String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                    this.writeDataImmediately(size.getBytes("GB18030"));
                    String GAP = "GAP 0 mm,0 mm\r\n";
                    if (cut && j == mlist.size() - 1 && i == bitmaps.length - 1) {
                        this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                    } else {
                        this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                    }
                    this.writeDataImmediately(GAP.getBytes("GB18030"));
                    String cls = "CLS\r\n";
                    this.writeDataImmediately(cls.getBytes("GB18030"));
                    if (compression) {
                        data = PDFUtils.drawTscPDFLib(mlist.get(j));
                        this.writeDataImmediately(data);
                    } else {
                        data = PDFUtils.drawTscPDF(mlist.get(j));
                        this.writeDataImmediately(data);
                    }
                    String print = "\r\nPRINT 1\r\n";
                    this.writeDataImmediately(print.getBytes("GB18030"));
                }
                if (i != bitmaps.length - 1) continue;
                mlist.clear();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeBitmapToTsc(Bitmap mBitmap, int printWidth, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (mBitmap == null) {
            throw new Exception("Bitmap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        if (mBitmap != null) {
            int width = (printWidth + 7) / 8 * 8;
            int height = mBitmap.getHeight() * width / mBitmap.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + mBitmap.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
            List<Bitmap> mlist = SerialPort.ImageCrop(rszBitmap, cutHeight);
            for (int j = 0; j < mlist.size(); ++j) {
                String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String gap = "GAP 0 mm,0 mm\r\n";
                this.writeDataImmediately(gap.getBytes("GB18030"));
                if (cut && j == mlist.size() - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                byte[] data = PDFUtils.drawTscPDFLib(mlist.get(j));
                this.writeDataImmediately(data);
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (j != mlist.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Bitmap> ImageCrop(Bitmap bitmap, int photoheight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        int last = bitmap.getHeight() % photoheight;
        for (int i = 0; i < bitmap.getHeight() - bitmap.getHeight() % photoheight; i += photoheight) {
            list.add(SerialPort.cutBitmap(bitmap, i, photoheight));
        }
        if (last > 0) {
            Bitmap cp = SerialPort.cutBitmap(bitmap, bitmap.getHeight() - bitmap.getHeight() % photoheight, bitmap.getHeight() % photoheight);
            list.add(cp);
        }
        return list;
    }

    public static Bitmap cutBitmap(Bitmap bitmap, int y, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Log.e((String)String.valueOf(w), (String)String.valueOf(h));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)w, (int)height, null, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeDataImmediately(Vector<Byte> sendData) throws IOException {
        int offset = 0;
        List<byte[]> mlist = SDKUtils.getListByteArray(SDKUtils.convertVectorByteToBytes(sendData), this.SINGLE_SIZE);
        int packNum = 0;
        try {
            while (packNum < mlist.size()) {
                if (this.isBusy) {
                    Thread.sleep(1000L);
                    Log.e((String)TAG, (String)"Waiting to send..");
                } else {
                    this.outputStream.write(mlist.get(packNum), offset, mlist.get(packNum).length);
                    this.outputStream.flush();
                    ++packNum;
                    Thread.sleep(10L);
                }
                if (this.isConn) continue;
                Log.e((String)TAG, (String)"Interrupt transmission");
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (packNum == mlist.size()) {
                mlist.clear();
                Log.e((String)TAG, (String)"send success");
                return true;
            }
            mlist.clear();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean writeDataImmediately(byte[] data) throws IOException {
        int offset = 0;
        List<byte[]> mlist = SDKUtils.getListByteArray(data, this.SINGLE_SIZE);
        int packNum = 0;
        try {
            while (packNum < mlist.size()) {
                if (this.isBusy) {
                    Thread.sleep(1000L);
                    Log.e((String)TAG, (String)"Waiting to send..");
                } else {
                    this.outputStream.write(mlist.get(packNum), offset, mlist.get(packNum).length);
                    this.outputStream.flush();
                    ++packNum;
                    Thread.sleep(10L);
                }
                if (this.isConn) continue;
                Log.e((String)TAG, (String)"Interrupt transmission");
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (packNum == mlist.size()) {
                mlist.clear();
                Log.e((String)TAG, (String)"send success");
                return true;
            }
            mlist.clear();
        }
        return false;
    }

    @Override
    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public PrinterDevices getPrinterDevices() {
        return this.mPrinterDevices;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPrinterStatus(Command command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 54[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrinterModel(Command command) throws IOException {
        if (command == null) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        switch (command) {
            case ESC: {
                byte[] esc = new byte[]{29, 73, 67};
                this.writeDataImmediately(esc);
                break;
            }
            case TSC: {
                byte[] tsc = new byte[]{126, 33, 84, 13, 10};
                this.writeDataImmediately(tsc);
                break;
            }
            case CPCL: {
                byte[] cpcl = new byte[]{27, 118};
                this.writeDataImmediately(cpcl);
            }
        }
        long endTime = SystemClock.uptimeMillis() + 2000L;
        byte[] recv = null;
        if (this.reader == null) {
            do {
                if (this.inputStream.available() > 0) {
                    if (recv == null) {
                        recv = new byte[this.inputStream.available()];
                    }
                    this.inputStream.read(recv);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (endTime > SystemClock.uptimeMillis());
        } else {
            Object object2 = this.lock;
            synchronized (object2) {
                while (endTime > SystemClock.uptimeMillis()) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
            LogUtils.e("model length" + this.byteArrayOutputStream.size());
            return this.byteArrayOutputStream.toString();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPower() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized int readData(byte[] bytes) throws IOException {
        if (this.inputStream == null) {
            throw new IOException();
        }
        int len = 0;
        try {
            len = this.inputStream.read(bytes);
            Log.e((String)TAG, (String)("read length" + len));
            return len;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"connection device is lost");
            throw e;
        }
    }

    @Override
    public synchronized boolean closePort() {
        try {
            this.mPrinterDevices = null;
            this.command = null;
            if (this.reader != null) {
                this.reader.cancel();
                this.reader.interrupt();
                this.reader = null;
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            if (this.serialPortControl != null) {
                this.serialPortControl.close();
                this.serialPortControl = null;
            }
            this.isConn = false;
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close the steam or serial port error!", (Throwable)e);
            return false;
        }
    }

    class IoReader
    extends Thread {
        private boolean isRun = true;

        public void cancel() {
            this.isRun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.isRun) {
                    SerialPort.this.len = SerialPort.this.inputStream.read(SerialPort.this.buffer);
                    if (SerialPort.this.len <= 0) continue;
                    Object object = SerialPort.this.lock;
                    synchronized (object) {
                        for (int i = 0; i < SerialPort.this.len; ++i) {
                            if (SerialPort.this.buffer[i] == 19) {
                                SerialPort.this.isBusy = true;
                                break;
                            }
                            if (SerialPort.this.buffer[i] != 17) continue;
                            SerialPort.this.isBusy = false;
                            break;
                        }
                        final byte[] receive = SDKUtils.subBytes(SerialPort.this.buffer, 0, SerialPort.this.len);
                        SerialPort.this.byteArrayOutputStream.write(receive);
                        SerialPort.this.lock.notifyAll();
                        Thread.sleep(10L);
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                SerialPort.this.callbackListener.onReceive(receive);
                            }
                        });
                    }
                }
                return;
            }
            catch (Exception e) {
                if (SerialPort.this.callbackListener == null) return;
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SerialPort.this.callbackListener.onDisconnect();
                    }
                });
            }
        }
    }
}

